
#R script for the analyses of the paper titled "The Susceptibility of Compound Remote Associate Problems to Disruption by Irrelevant Sound:
#A Window onto the Component Processes Underpinning Creative Cognition? submitted to Journal of Cognitive Psychology.

#### SOLUTION RATES ####

#### LIBRARIES ####
#Install
install.packages("languageR") 
install.packages("lme4")
install.packages("lattice") 
install.packages("lmerTest")
install.packages("MASS") 
install.packages("plyr")
install.packages("pbkrtest")
install.packages("effects")

#Upload
library(languageR)
library(lme4)
library(lattice)
library(lmerTest)
library(MASS)
library(plyr)
library(pbkrtest)
library(effects)

#### SOLUTION RATES ####
#### EXPERIMENT 1 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology/revision3") # Set the working directory
getwd()

datafile = read.csv("Experiment1.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Easy"] <-3
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Hard"] <-4
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty=="Easy"] <-5
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty== "Hard"] <-6
head(datafile)

table(datafile$newcondition) #cond1: 480; cond2: 432; cond3: 480; cond4: 432; cond5: 480; cond6: 432.
table(datafile$Sound) #CS: 912, quiet: 912, SS: 912.
table(datafile$Difficulty) #Easy: 1440, Hard: 1296.

#Create a new variable 'nitem'
datafile$nitem[datafile$Set == 1 & datafile$Item == 1] <-1
datafile$nitem[datafile$Set == 1 & datafile$Item == 2] <-2
datafile$nitem[datafile$Set == 1 & datafile$Item == 3] <-3
datafile$nitem[datafile$Set == 1 & datafile$Item == 4] <-4
datafile$nitem[datafile$Set == 1 & datafile$Item == 5] <-5
datafile$nitem[datafile$Set == 1 & datafile$Item == 6] <-6
datafile$nitem[datafile$Set == 1 & datafile$Item == 7] <-7
datafile$nitem[datafile$Set == 1 & datafile$Item == 8] <-8
datafile$nitem[datafile$Set == 1 & datafile$Item == 9] <-9
datafile$nitem[datafile$Set == 1 & datafile$Item == 10] <-10
datafile$nitem[datafile$Set == 1 & datafile$Item == 11] <-11
datafile$nitem[datafile$Set == 1 & datafile$Item == 12] <-12
datafile$nitem[datafile$Set == 1 & datafile$Item == 13] <-13
datafile$nitem[datafile$Set == 1 & datafile$Item == 14] <-14
datafile$nitem[datafile$Set == 1 & datafile$Item == 15] <-15
datafile$nitem[datafile$Set == 1 & datafile$Item == 16] <-16
datafile$nitem[datafile$Set == 1 & datafile$Item == 17] <-17
datafile$nitem[datafile$Set == 1 & datafile$Item == 18] <-18
datafile$nitem[datafile$Set == 1 & datafile$Item == 19] <-19

datafile$nitem[datafile$Set == 2 & datafile$Item == 1] <-20
datafile$nitem[datafile$Set == 2 & datafile$Item == 2] <-21
datafile$nitem[datafile$Set == 2 & datafile$Item == 3] <-22
datafile$nitem[datafile$Set == 2 & datafile$Item == 4] <-23
datafile$nitem[datafile$Set == 2 & datafile$Item == 5] <-24
datafile$nitem[datafile$Set == 2 & datafile$Item == 6] <-25
datafile$nitem[datafile$Set == 2 & datafile$Item == 7] <-26
datafile$nitem[datafile$Set == 2 & datafile$Item == 8] <-27
datafile$nitem[datafile$Set == 2 & datafile$Item == 9] <-28
datafile$nitem[datafile$Set == 2 & datafile$Item == 10] <-29
datafile$nitem[datafile$Set == 2 & datafile$Item == 11] <-30
datafile$nitem[datafile$Set == 2 & datafile$Item == 12] <-31
datafile$nitem[datafile$Set == 2 & datafile$Item == 13] <-32
datafile$nitem[datafile$Set == 2 & datafile$Item == 14] <-33
datafile$nitem[datafile$Set == 2 & datafile$Item == 15] <-34
datafile$nitem[datafile$Set == 2 & datafile$Item == 16] <-35
datafile$nitem[datafile$Set == 2 & datafile$Item == 17] <-36
datafile$nitem[datafile$Set == 2 & datafile$Item == 18] <-37
datafile$nitem[datafile$Set == 2 & datafile$Item == 19] <-38

datafile$nitem[datafile$Set == 3 & datafile$Item == 1] <-39
datafile$nitem[datafile$Set == 3 & datafile$Item == 2] <-40
datafile$nitem[datafile$Set == 3 & datafile$Item == 3] <-41
datafile$nitem[datafile$Set == 3 & datafile$Item == 4] <-42
datafile$nitem[datafile$Set == 3 & datafile$Item == 5] <-43
datafile$nitem[datafile$Set == 3 & datafile$Item == 6] <-44
datafile$nitem[datafile$Set == 3 & datafile$Item == 7] <-45
datafile$nitem[datafile$Set == 3 & datafile$Item == 8] <-46
datafile$nitem[datafile$Set == 3 & datafile$Item == 9] <-47
datafile$nitem[datafile$Set == 3 & datafile$Item == 10] <-48
datafile$nitem[datafile$Set == 3 & datafile$Item == 11] <-49
datafile$nitem[datafile$Set == 3 & datafile$Item == 12] <-50
datafile$nitem[datafile$Set == 3 & datafile$Item == 13] <-51
datafile$nitem[datafile$Set == 3 & datafile$Item == 14] <-52
datafile$nitem[datafile$Set == 3 & datafile$Item == 15] <-53
datafile$nitem[datafile$Set == 3 & datafile$Item == 16] <-54
datafile$nitem[datafile$Set == 3 & datafile$Item == 17] <-55
datafile$nitem[datafile$Set == 3 & datafile$Item == 18] <-56
datafile$nitem[datafile$Set == 3 & datafile$Item == 19] <-57

unique(datafile$nitem) #57 (unique) items
head(datafile)

#### 2. Set up variables ####
colnames(datafile) #checked the column names
col.subject =1   # specify which column your participant number is in ("Participant" column)
col.condition =9 # specify which column contains your condition number ("newcondition" column)
col.stim =10 # specify which column your item number is in ("nitem" column)
measure =  "correct" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile$depvar = datafile[,measure]
head(datafile) # Generally check the file

#Add to dataframe fixed and random factors columns
datafile$pp = datafile[,col.subject]
datafile$condition = datafile[,col.condition]
datafile$stim = datafile[,col.stim]
head(datafile) # Generally check the file

#Make sure all variables are correct class
datafile$depvar = as.numeric(datafile$depvar)
datafile$stim = as.factor(datafile$stim)
datafile$condition = as.factor(datafile$condition)
datafile$Sound = as.factor(datafile$Sound)
datafile$Difficulty = as.factor(datafile$Difficulty)
datafile$Set = as.factor(datafile$Set)
str(datafile)

#### 3. Means,Standard Deviations and Standard Errors ####
#Step1a: make a matrix with the means per subject and per condition for the dependent variable
mean.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), mean, na.rm = T)
mean.matrix

#Step1b: make a matrix with the standard deviations per subject and per condition for the dependent variable
sd.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), sd, na.rm = T)
sd.matrix

#Step2:Calculate the grand mean by condition 
grand.mean=apply(mean.matrix, 2, mean, na.rm = T)
grand.mean
grand.sd=apply(mean.matrix,2,sd, na.rm = T)
grand.sd
grand.se=grand.sd/sqrt(48) ##The number of the participants is 48. 
grand.se

sink("Experiment1_SolutionRate_Means&SD&SE.txt")
grand.mean
grand.sd
grand.se
sink()

#### 4. Linear Mixed Models (LME models)####
#Step1: Check the levels of Difficulty and Sound
head(datafile) # Generally check the file
levels(datafile$Difficulty) # "Easy", "Hard"
levels(datafile$Difficulty)[match("Easy",levels(datafile$Difficulty))] <- "1Easy"
levels(datafile$Difficulty)[match("Hard",levels(datafile$Difficulty))] <- "2Hard"
levels(datafile$Difficulty) # "1Easy", "2Hard"

levels(datafile$Sound) # "CS"    "Quiet" "SS"  
levels(datafile$Sound)[match("Quiet",levels(datafile$Sound))] <- "1Quiet"
levels(datafile$Sound)[match("SS",levels(datafile$Sound))] <- "2SS"
levels(datafile$Sound)[match("CS",levels(datafile$Sound))] <- "3CS"
datafile$Sound <- factor(datafile$Sound, levels = c("1Quiet", "2SS", "3CS")) #Set up the order of the levels of the Sound conditions
levels(datafile$Sound) # "1Quiet" "2SS" "3CS" 
head(datafile) # Generally check the file

#Step2: Add contrasts
contrasts(datafile$Difficulty) <- contr.sdif(2) #2 levels of difficulty: 1Easy, 2Hard
contrasts(datafile$Sound) <- contr.sdif(3) #3 levels of sound: 1Quiet, 2SS, 3CS

#Step3: Run the model(s)
#Final model
Adepvar.glmer6 = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty |pp)  + (1|stim), datafile, family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer6, corr = FALSE)

#Step4: Calculate Confidence Interaction for the model that converges
Confint.glmer6 = confint(Adepvar.glmer6, method="Wald")

#### 5. Print model, CI, and graph ####
sink("Experiment1_SolutionRate_Model6.txt")
summary(Adepvar.glmer6, corr=FALSE)
sink()

sink("Experiment1_SolutionRate_CI6.txt")
Confint.glmer6
sink()

#Graphs to see the interaction
jpeg('Experiment1_SolutionRate_graphInteraction6.jpeg')
allEffects(Adepvar.glmer6)# call the particular model you want to see all the effect of
plot(allEffects(Adepvar.glmer6), multiline = TRUE)
dev.off()

#### EXPERIMENT 2 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology/revision3") # Set the working directory
getwd()

datafile = read.csv("Experiment2.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Easy"] <-3
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Hard"] <-4
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty=="Easy"] <-5
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty== "Hard"] <-6
head(datafile)

table(datafile$newcondition) #cond1: 360; cond2: 324; cond3: 360; cond4: 324; cond5: 360; cond6: 324
table(datafile$Sound) #CS: 684, quiet: 684, SS: 684.
table(datafile$Difficulty) #Easy: 1080, Hard: 972.

#Create a new variable 'nitem'
datafile$nitem[datafile$Set == 1 & datafile$Item == 1] <-1
datafile$nitem[datafile$Set == 1 & datafile$Item == 2] <-2
datafile$nitem[datafile$Set == 1 & datafile$Item == 3] <-3
datafile$nitem[datafile$Set == 1 & datafile$Item == 4] <-4
datafile$nitem[datafile$Set == 1 & datafile$Item == 5] <-5
datafile$nitem[datafile$Set == 1 & datafile$Item == 6] <-6
datafile$nitem[datafile$Set == 1 & datafile$Item == 7] <-7
datafile$nitem[datafile$Set == 1 & datafile$Item == 8] <-8
datafile$nitem[datafile$Set == 1 & datafile$Item == 9] <-9
datafile$nitem[datafile$Set == 1 & datafile$Item == 10] <-10
datafile$nitem[datafile$Set == 1 & datafile$Item == 11] <-11
datafile$nitem[datafile$Set == 1 & datafile$Item == 12] <-12
datafile$nitem[datafile$Set == 1 & datafile$Item == 13] <-13
datafile$nitem[datafile$Set == 1 & datafile$Item == 14] <-14
datafile$nitem[datafile$Set == 1 & datafile$Item == 15] <-15
datafile$nitem[datafile$Set == 1 & datafile$Item == 16] <-16
datafile$nitem[datafile$Set == 1 & datafile$Item == 17] <-17
datafile$nitem[datafile$Set == 1 & datafile$Item == 18] <-18
datafile$nitem[datafile$Set == 1 & datafile$Item == 19] <-19

datafile$nitem[datafile$Set == 2 & datafile$Item == 1] <-20
datafile$nitem[datafile$Set == 2 & datafile$Item == 2] <-21
datafile$nitem[datafile$Set == 2 & datafile$Item == 3] <-22
datafile$nitem[datafile$Set == 2 & datafile$Item == 4] <-23
datafile$nitem[datafile$Set == 2 & datafile$Item == 5] <-24
datafile$nitem[datafile$Set == 2 & datafile$Item == 6] <-25
datafile$nitem[datafile$Set == 2 & datafile$Item == 7] <-26
datafile$nitem[datafile$Set == 2 & datafile$Item == 8] <-27
datafile$nitem[datafile$Set == 2 & datafile$Item == 9] <-28
datafile$nitem[datafile$Set == 2 & datafile$Item == 10] <-29
datafile$nitem[datafile$Set == 2 & datafile$Item == 11] <-30
datafile$nitem[datafile$Set == 2 & datafile$Item == 12] <-31
datafile$nitem[datafile$Set == 2 & datafile$Item == 13] <-32
datafile$nitem[datafile$Set == 2 & datafile$Item == 14] <-33
datafile$nitem[datafile$Set == 2 & datafile$Item == 15] <-34
datafile$nitem[datafile$Set == 2 & datafile$Item == 16] <-35
datafile$nitem[datafile$Set == 2 & datafile$Item == 17] <-36
datafile$nitem[datafile$Set == 2 & datafile$Item == 18] <-37
datafile$nitem[datafile$Set == 2 & datafile$Item == 19] <-38

datafile$nitem[datafile$Set == 3 & datafile$Item == 1] <-39
datafile$nitem[datafile$Set == 3 & datafile$Item == 2] <-40
datafile$nitem[datafile$Set == 3 & datafile$Item == 3] <-41
datafile$nitem[datafile$Set == 3 & datafile$Item == 4] <-42
datafile$nitem[datafile$Set == 3 & datafile$Item == 5] <-43
datafile$nitem[datafile$Set == 3 & datafile$Item == 6] <-44
datafile$nitem[datafile$Set == 3 & datafile$Item == 7] <-45
datafile$nitem[datafile$Set == 3 & datafile$Item == 8] <-46
datafile$nitem[datafile$Set == 3 & datafile$Item == 9] <-47
datafile$nitem[datafile$Set == 3 & datafile$Item == 10] <-48
datafile$nitem[datafile$Set == 3 & datafile$Item == 11] <-49
datafile$nitem[datafile$Set == 3 & datafile$Item == 12] <-50
datafile$nitem[datafile$Set == 3 & datafile$Item == 13] <-51
datafile$nitem[datafile$Set == 3 & datafile$Item == 14] <-52
datafile$nitem[datafile$Set == 3 & datafile$Item == 15] <-53
datafile$nitem[datafile$Set == 3 & datafile$Item == 16] <-54
datafile$nitem[datafile$Set == 3 & datafile$Item == 17] <-55
datafile$nitem[datafile$Set == 3 & datafile$Item == 18] <-56
datafile$nitem[datafile$Set == 3 & datafile$Item == 19] <-57

unique(datafile$nitem) #57 (unique) items
head(datafile)

#### 2. Set up variables ####
colnames(datafile) #checked the column names
col.subject =1   # specify which column your participant number is in ("Participant" column)
col.condition =7 # specify which column contains your condition number ("newcondition" column)
col.stim =8 # specify which column your item number is in ("nitem" column)
measure =  "Correct" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile$depvar = datafile[,measure]
head(datafile) # Generally check the file

#Add to dataframe the fixed and random factors columns
datafile$pp = datafile[,col.subject]
datafile$condition = datafile[,col.condition]
datafile$stim = datafile[,col.stim]
head(datafile) # Generally check the file

#Make sure all variables are correct class
datafile$depvar = as.numeric(datafile$depvar)
datafile$stim = as.factor(datafile$stim)
datafile$condition = as.factor(datafile$condition)
datafile$Sound = as.factor(datafile$Sound)
datafile$Difficulty = as.factor(datafile$Difficulty)
datafile$Set = as.factor(datafile$Set)
str(datafile)

#### 3. Means,Standard Deviations and Standard Errors ####
#Step1a: make a matrix with the means per subject and per condition for the dependent variable
mean.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), mean, na.rm = T)
mean.matrix

#Step1b: make a matrix with the standard deviations per subject and per condition for the dependent variable
sd.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), sd, na.rm = T)
sd.matrix

#Step2:Calculate the grand mean by condition 
grand.mean=apply(mean.matrix, 2, mean, na.rm = T)
grand.mean
grand.sd=apply(mean.matrix,2,sd, na.rm = T)
grand.sd
grand.se=grand.sd/sqrt(36) ##The number of the participants is 36. 
grand.se

sink("Experiment2_SolutionRate_Means&SD&SE.txt")
grand.mean
grand.sd
grand.se
sink()

#### 4. Linear Mixed Models (LME models)####
#Step1: Check the levels of Difficulty and Sound
head(datafile) # Generally check the file
levels(datafile$Difficulty) # "Easy", "Hard"
levels(datafile$Difficulty)[match("Easy",levels(datafile$Difficulty))] <- "1Easy"
levels(datafile$Difficulty)[match("Hard",levels(datafile$Difficulty))] <- "2Hard"
levels(datafile$Difficulty) # "1Easy", "2Hard"

levels(datafile$Sound) # "CS"    "Quiet" "SS"  
levels(datafile$Sound)[match("Quiet",levels(datafile$Sound))] <- "1Quiet"
levels(datafile$Sound)[match("SS",levels(datafile$Sound))] <- "2SS"
levels(datafile$Sound)[match("CS",levels(datafile$Sound))] <- "3CS"
datafile$Sound <- factor(datafile$Sound, levels = c("1Quiet", "2SS", "3CS")) #Set up the order of the levels of the Sound conditions
levels(datafile$Sound) # "1Quiet" "2SS" "3CS" 
head(datafile) # Generally check the file

#Step2: Add contrasts
contrasts(datafile$Difficulty) <- contr.sdif(2) #2 levels of difficulty: Easy, Hard
contrasts(datafile$Sound) <- contr.sdif(3) #3 levels of sound: 1Quiet, 2SS, 3CS

#Step3: Run the model(s)
#Final model
Adepvar.glmer6 = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty |pp)  + (1|stim), datafile, family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer6, corr = FALSE)

#Step4: Calculate Confidence Interaction for the model that converges
Confint.glmer6 = confint(Adepvar.glmer6, method="Wald")

#### 5. Print model, CI, and graph ####
sink("Experiment2_SolutionRate_Model6.txt")
summary(Adepvar.glmer6, corr=FALSE)
sink()

sink("Experiment2_SolutionRate_CI6.txt")
Confint.glmer6
sink()

#Graphs to see the interaction
jpeg('Experiment2_SolutionRate_graphInteraction6.jpeg')
allEffects(Adepvar.glmer6)# call the particular model you want to see all the effect of
plot(allEffects(Adepvar.glmer6), multiline = TRUE)
dev.off()

#### EXPERIMENT 3 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology/revision3") # Set the working directory
getwd()

datafile = read.csv("Experiment3.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Easy"] <-3 #meaningless
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Hard"] <-4 #meaningless
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty=="Easy"] <-5 #meaningful
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty== "Hard"] <-6 #meaningful
head(datafile)

table(datafile$newcondition) #cond1: 300; cond2: 300; cond3: 300; cond4: 300; cond5: 300; cond6: 300
table(datafile$Sound) #forward: 600, quiet: 600, reversed: 600
table(datafile$Difficulty) #Easy: 900, Hard: 900

#Create a new variable 'nitem'
datafile$nitem[datafile$Set == 1 & datafile$Item == 1] <-1
datafile$nitem[datafile$Set == 1 & datafile$Item == 2] <-2
datafile$nitem[datafile$Set == 1 & datafile$Item == 3] <-3
datafile$nitem[datafile$Set == 1 & datafile$Item == 4] <-4
datafile$nitem[datafile$Set == 1 & datafile$Item == 5] <-5
datafile$nitem[datafile$Set == 1 & datafile$Item == 6] <-6
datafile$nitem[datafile$Set == 1 & datafile$Item == 7] <-7
datafile$nitem[datafile$Set == 1 & datafile$Item == 8] <-8
datafile$nitem[datafile$Set == 1 & datafile$Item == 9] <-9
datafile$nitem[datafile$Set == 1 & datafile$Item == 10] <-10
datafile$nitem[datafile$Set == 1 & datafile$Item == 11] <-11
datafile$nitem[datafile$Set == 1 & datafile$Item == 12] <-12
datafile$nitem[datafile$Set == 1 & datafile$Item == 13] <-13
datafile$nitem[datafile$Set == 1 & datafile$Item == 14] <-14
datafile$nitem[datafile$Set == 1 & datafile$Item == 15] <-15
datafile$nitem[datafile$Set == 1 & datafile$Item == 16] <-16
datafile$nitem[datafile$Set == 1 & datafile$Item == 17] <-17
datafile$nitem[datafile$Set == 1 & datafile$Item == 18] <-18
datafile$nitem[datafile$Set == 1 & datafile$Item == 19] <-19
datafile$nitem[datafile$Set == 1 & datafile$Item == 20] <-20

datafile$nitem[datafile$Set == 2 & datafile$Item == 1] <-21
datafile$nitem[datafile$Set == 2 & datafile$Item == 2] <-22
datafile$nitem[datafile$Set == 2 & datafile$Item == 3] <-23
datafile$nitem[datafile$Set == 2 & datafile$Item == 4] <-24
datafile$nitem[datafile$Set == 2 & datafile$Item == 5] <-25
datafile$nitem[datafile$Set == 2 & datafile$Item == 6] <-26
datafile$nitem[datafile$Set == 2 & datafile$Item == 7] <-27
datafile$nitem[datafile$Set == 2 & datafile$Item == 8] <-28
datafile$nitem[datafile$Set == 2 & datafile$Item == 9] <-29
datafile$nitem[datafile$Set == 2 & datafile$Item == 10] <-30
datafile$nitem[datafile$Set == 2 & datafile$Item == 11] <-31
datafile$nitem[datafile$Set == 2 & datafile$Item == 12] <-32
datafile$nitem[datafile$Set == 2 & datafile$Item == 13] <-33
datafile$nitem[datafile$Set == 2 & datafile$Item == 14] <-34
datafile$nitem[datafile$Set == 2 & datafile$Item == 15] <-35
datafile$nitem[datafile$Set == 2 & datafile$Item == 16] <-36
datafile$nitem[datafile$Set == 2 & datafile$Item == 17] <-37
datafile$nitem[datafile$Set == 2 & datafile$Item == 18] <-38
datafile$nitem[datafile$Set == 2 & datafile$Item == 19] <-39
datafile$nitem[datafile$Set == 2 & datafile$Item == 20] <-40

datafile$nitem[datafile$Set == 3 & datafile$Item == 1] <-41
datafile$nitem[datafile$Set == 3 & datafile$Item == 2] <-42
datafile$nitem[datafile$Set == 3 & datafile$Item == 3] <-43
datafile$nitem[datafile$Set == 3 & datafile$Item == 4] <-44
datafile$nitem[datafile$Set == 3 & datafile$Item == 5] <-45
datafile$nitem[datafile$Set == 3 & datafile$Item == 6] <-46
datafile$nitem[datafile$Set == 3 & datafile$Item == 7] <-47
datafile$nitem[datafile$Set == 3 & datafile$Item == 8] <-48
datafile$nitem[datafile$Set == 3 & datafile$Item == 9] <-49
datafile$nitem[datafile$Set == 3 & datafile$Item == 10] <-50
datafile$nitem[datafile$Set == 3 & datafile$Item == 11] <-51
datafile$nitem[datafile$Set == 3 & datafile$Item == 12] <-52
datafile$nitem[datafile$Set == 3 & datafile$Item == 13] <-53
datafile$nitem[datafile$Set == 3 & datafile$Item == 14] <-54
datafile$nitem[datafile$Set == 3 & datafile$Item == 15] <-55
datafile$nitem[datafile$Set == 3 & datafile$Item == 16] <-56
datafile$nitem[datafile$Set == 3 & datafile$Item == 17] <-57
datafile$nitem[datafile$Set == 3 & datafile$Item == 18] <-58
datafile$nitem[datafile$Set == 3 & datafile$Item == 19] <-59
datafile$nitem[datafile$Set == 3 & datafile$Item == 20] <-60

unique(datafile$nitem) #60 (unique) items
head(datafile)

#### 2. Set up variables ####
colnames(datafile) #checked the column names
col.subject =1   # specify which column your participant number is in ("Participant" column)
col.condition =8 # specify which column contains your condition number ("newcondition" column)
col.stim =9 # specify which column your item number is in ("nitem" column)
measure =  "Correct" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile$depvar = datafile[,measure]
head(datafile) # Generally check the file

#Add to dataframe the fixed and random factors column
datafile$pp = datafile[,col.subject]
datafile$condition = datafile[,col.condition]
datafile$stim = datafile[,col.stim]
head(datafile) # Generally check the file

#Make sure all variables are correct class
datafile$depvar = as.numeric(datafile$depvar)
datafile$stim = as.factor(datafile$stim)
datafile$condition = as.factor(datafile$condition)
datafile$Sound = as.factor(datafile$Sound)
datafile$Difficulty = as.factor(datafile$Difficulty)
datafile$Set = as.factor(datafile$Set)
str(datafile)

#### 3. Means,Standard Deviations and Standard Errors ####
#Step1a: make a matrix with the means per subject and per condition for the dependent variable
mean.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), mean, na.rm = T)
mean.matrix

#Step1b: make a matrix with the standard deviations per subject and per condition for the dependent variable
sd.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), sd, na.rm = T)
sd.matrix

#Step2:Calculate the grand mean by condition 
grand.mean=apply(mean.matrix, 2, mean, na.rm = T)
grand.mean
grand.sd=apply(mean.matrix,2,sd, na.rm = T)
grand.sd
grand.se=grand.sd/sqrt(30) ##The number of the participants is 30. 
grand.se

sink("Experiment3_SolutionRate_Means&SD&SE.txt")
grand.mean
grand.sd
grand.se
sink()

#### 4. Linear Mixed Models (LME models)####
#Step1: Check the levels of Difficulty and Sound
head(datafile) # Generally check the file
levels(datafile$Difficulty) # "Easy", "Hard"
levels(datafile$Difficulty)[match("Easy",levels(datafile$Difficulty))] <- "1Easy"
levels(datafile$Difficulty)[match("Hard",levels(datafile$Difficulty))] <- "2Hard"
levels(datafile$Difficulty) # "1Easy", "2Hard"

levels(datafile$Sound) # "forward"  "quiet"    "reversed" 
levels(datafile$Sound)[match("quiet",levels(datafile$Sound))] <- "1quiet"
levels(datafile$Sound)[match("reversed",levels(datafile$Sound))] <- "2reversed"
levels(datafile$Sound)[match("forward",levels(datafile$Sound))] <- "3forward"
datafile$Sound <- factor(datafile$Sound, levels = c("1quiet", "2reversed", "3forward")) #Set up the order of the levels of the Sound conditions
levels(datafile$Sound) # "1quiet"    "2reversed" "3forward" 
head(datafile) # Generally check the file

#Step2: Add contrasts
contrasts(datafile$Difficulty) <- contr.sdif(2) #2 levels of difficulty: Easy, Hard
contrasts(datafile$Sound) <- contr.sdif(3) #3 levels of sound: 1quiet, 2reversed, 3forward

#Step3: Run the model(s)
#Final model
Adepvar.glmer6 = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty |pp)  + (1|stim), datafile, family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer6, corr = FALSE)

#Step4: Calculate Confidence Interaction for the model that converges
Confint.glmer6 = confint(Adepvar.glmer6, method="Wald")

#### 5. Print model, CI, and graph ####
sink("Experiment3_SolutionRate_Model6.txt")
summary(Adepvar.glmer6, corr=FALSE)
sink()

sink("Experiment3_SolutionRate_CI6.txt")
Confint.glmer6
sink()

#Graphs to see the interaction
jpeg('Experiment3_SolutionRate_graphInteraction6.jpeg')
allEffects(Adepvar.glmer6)# call the particular model you want to see all the effect of
plot(allEffects(Adepvar.glmer6), multiline = TRUE)
dev.off()

##### ############################################################################################# ####